<?php
/**
 * صفحة عرض أعلام الدول
 * تقوم هذه الصفحة بعرض أعلام الدول المتاحة في النظام
 */

// تضمين ملف التكوين
require_once 'config/config.php';

// تضمين ملف الأمان
require_once 'config/security.php';

// تضمين ملف الدوال المساعدة
require_once 'includes/functions.php';

// التحقق من حالة تسجيل الدخول
if (!isLoggedIn()) {
    // إعادة توجيه المستخدم إلى صفحة تسجيل الدخول
    header('Location: login.php');
    exit;
}

// الحصول على قائمة الدول
$countries = [];
try {
    $stmt = $pdo->query("SELECT * FROM countries ORDER BY name");
    $countries = $stmt->fetchAll();
} catch (PDOException $e) {
    // تجاهل الخطأ
}

// الحصول على قائمة صور الأعلام المتاحة
$flags = [];
$flagsDir = 'assets/images/flags/';
if (is_dir($flagsDir)) {
    $files = scandir($flagsDir);
    foreach ($files as $file) {
        if ($file !== '.' && $file !== '..' && is_file($flagsDir . $file)) {
            $flags[] = [
                'name' => pathinfo($file, PATHINFO_FILENAME),
                'path' => $flagsDir . $file
            ];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>عرض أعلام الدول | نظام طلبات الشحن</title>
    <link rel="stylesheet" href="assets/css/styles.css">
    <style>
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        h1 {
            color: #0a2056;
            margin-bottom: 30px;
        }
        
        .flags-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }
        
        .flag-card {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            transition: transform 0.3s;
        }
        
        .flag-card:hover {
            transform: translateY(-5px);
        }
        
        .flag-image {
            height: 120px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #f9f9f9;
            padding: 10px;
        }
        
        .flag-image img {
            max-width: 100%;
            max-height: 100px;
            object-fit: contain;
        }
        
        .flag-info {
            padding: 15px;
        }
        
        .flag-name {
            font-size: 18px;
            font-weight: bold;
            margin: 0 0 5px;
            color: #0a2056;
        }
        
        .flag-code {
            font-size: 14px;
            color: #6b7280;
            margin: 0;
        }
        
        .back-link {
            display: inline-block;
            margin-top: 20px;
            color: #0a2056;
            text-decoration: none;
        }
        
        .back-link:hover {
            text-decoration: underline;
        }
        
        .no-flags {
            text-align: center;
            padding: 50px;
            background-color: #f9f9f9;
            border-radius: 8px;
            color: #6b7280;
        }
        
        .actions {
            margin-top: 20px;
            display: flex;
            gap: 10px;
        }
        
        .action-button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #0a2056;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            transition: background-color 0.3s;
        }
        
        .action-button:hover {
            background-color: #0f3385;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>عرض أعلام الدول</h1>
        
        <div class="actions">
            <a href="upload_flags.php" class="action-button">تحميل علم جديد</a>
            <a href="download_flags.php" class="action-button">تنزيل أعلام الدول</a>
            <a href="dashboard.php" class="action-button">العودة إلى لوحة التحكم</a>
        </div>
        
        <?php if (empty($countries) && empty($flags)): ?>
        <div class="no-flags">
            <p>لا توجد أعلام متاحة حاليًا. يرجى تحميل أعلام الدول أو تنزيلها من الإنترنت.</p>
        </div>
        <?php else: ?>
        <div class="flags-grid">
            <?php if (!empty($countries)): ?>
                <?php foreach ($countries as $country): ?>
                <div class="flag-card">
                    <div class="flag-image">
                        <?php if (!empty($country['flag_path']) && file_exists($country['flag_path'])): ?>
                        <img src="<?php echo $country['flag_path']; ?>" alt="<?php echo $country['name']; ?>">
                        <?php else: ?>
                        <div style="color: #6b7280;">لا توجد صورة</div>
                        <?php endif; ?>
                    </div>
                    <div class="flag-info">
                        <h3 class="flag-name"><?php echo $country['name']; ?></h3>
                        <?php if (!empty($country['code'])): ?>
                        <p class="flag-code">الرمز: <?php echo $country['code']; ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php elseif (!empty($flags)): ?>
                <?php foreach ($flags as $flag): ?>
                <div class="flag-card">
                    <div class="flag-image">
                        <img src="<?php echo $flag['path']; ?>" alt="<?php echo $flag['name']; ?>">
                    </div>
                    <div class="flag-info">
                        <h3 class="flag-name"><?php echo $flag['name']; ?></h3>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
