<?php
/**
 * أداة إعادة تعيين كلمة مرور MySQL
 * 
 * هذا الملف يساعد في إعادة تعيين كلمة مرور مستخدم MySQL
 * يمكن استخدامه لإعادة تعيين كلمة مرور المستخدم الجذر (root) أو أي مستخدم آخر
 */

// تعيين رأس HTTP للتعامل مع الترميز العربي
header('Content-Type: text/html; charset=utf-8');

// تحديد مسار تنفيذ PHP (يمكن تغييره حسب الإعداد)
$php_executable = 'C:\xampp\php\php.exe';

// متغيرات لتخزين الرسائل
$message = '';
$error = '';
$success = '';

// التحقق من إرسال النموذج
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // الحصول على البيانات المرسلة
    $username = isset($_POST['username']) ? $_POST['username'] : 'root';
    $new_password = isset($_POST['new_password']) ? $_POST['new_password'] : '';
    $confirm_password = isset($_POST['confirm_password']) ? $_POST['confirm_password'] : '';
    $host = isset($_POST['host']) ? $_POST['host'] : '127.0.0.1';
    
    // التحقق من تطابق كلمات المرور
    if ($new_password !== $confirm_password) {
        $error = 'كلمات المرور غير متطابقة. يرجى المحاولة مرة أخرى.';
    } elseif (empty($new_password)) {
        $error = 'كلمة المرور لا يمكن أن تكون فارغة.';
    } else {
        // إنشاء أمر SQL لتغيير كلمة المرور
        $sql_command = "ALTER USER '$username'@'%' IDENTIFIED BY '$new_password';";
        $sql_command .= "ALTER USER '$username'@'localhost' IDENTIFIED BY '$new_password';";
        $sql_command .= "FLUSH PRIVILEGES;";
        
        // كتابة الأمر SQL إلى ملف مؤقت
        $temp_file = tempnam(sys_get_temp_dir(), 'mysql_reset_');
        file_put_contents($temp_file, $sql_command);
        
        // إنشاء أمر لتنفيذ الأمر SQL باستخدام MySQL
        $command = "\"C:\\xampp\\mysql\\bin\\mysql.exe\" -u root -h $host < \"$temp_file\" 2>&1";
        
        // تنفيذ الأمر وحفظ النتيجة
        exec($command, $output, $return_var);
        
        // حذف الملف المؤقت
        @unlink($temp_file);
        
        // التحقق من نجاح العملية
        if ($return_var === 0) {
            $success = "تم تغيير كلمة مرور المستخدم '$username' بنجاح.";
            
            // تحديث ملف الاتصال بقاعدة البيانات إذا كان المستخدم هو root
            if ($username === 'root') {
                $db_config_file = 'config/db_connection.php';
                if (file_exists($db_config_file)) {
                    $db_config = file_get_contents($db_config_file);
                    
                    // تحديث كلمة المرور في ملف الاتصال
                    $db_config = preg_replace(
                        "/\\\$password = '.*?';/",
                        "\$password = '$new_password';",
                        $db_config
                    );
                    
                    // حفظ التغييرات
                    file_put_contents($db_config_file, $db_config);
                    $success .= " تم تحديث ملف الاتصال بقاعدة البيانات.";
                }
            }
        } else {
            $error = "حدث خطأ أثناء تغيير كلمة المرور: " . implode("\n", $output);
        }
    }
}
?>

<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعادة تعيين كلمة مرور MySQL</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            color: #333;
            text-align: center;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            background-color: #4CAF50;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
        }
        button:hover {
            background-color: #45a049;
        }
        .alert {
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 4px;
        }
        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .note {
            background-color: #fff3cd;
            color: #856404;
            padding: 10px;
            border-radius: 4px;
            margin-top: 20px;
            border: 1px solid #ffeeba;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>إعادة تعيين كلمة مرور MySQL</h1>
        
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <form method="post" action="">
            <div class="form-group">
                <label for="username">اسم المستخدم:</label>
                <input type="text" id="username" name="username" value="root" required>
            </div>
            
            <div class="form-group">
                <label for="host">المضيف:</label>
                <input type="text" id="host" name="host" value="127.0.0.1" required>
            </div>
            
            <div class="form-group">
                <label for="new_password">كلمة المرور الجديدة:</label>
                <input type="password" id="new_password" name="new_password" required>
            </div>
            
            <div class="form-group">
                <label for="confirm_password">تأكيد كلمة المرور:</label>
                <input type="password" id="confirm_password" name="confirm_password" required>
            </div>
            
            <button type="submit">إعادة تعيين كلمة المرور</button>
        </form>
        
        <div class="note">
            <strong>ملاحظة:</strong> هذه الأداة تتطلب وصولاً إلى خادم MySQL. إذا كنت تستخدم XAMPP، تأكد من تشغيل خدمة MySQL قبل استخدام هذه الأداة.
        </div>
    </div>
</body>
</html>
