<?php
// تضمين ملف التحقق من تسجيل الدخول
require_once 'check_auth.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>نظام طلبات الشحن | إعدادات الحساب</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    :root {
      --primary: #4f46e5;
      --primary-light: #818cf8;
      --secondary: #f59e0b;
      --dark: #1e293b;
      --light: #f8fafc;
    }

    @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;600;700&display=swap');

    body {
      font-family: 'Tajawal', sans-serif;
      background-color: #f1f5f9;
      color: var(--dark);
    }

    /* تصميم المحتوى الرئيسي */
    .main-content {
      transition: margin-right 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    /* كروت الحساب */
    .account-card {
      background: white;
      border-radius: 12px;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .account-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }

    /* أزرار */
    .btn-primary {
      background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
      transition: all 0.3s ease;
      box-shadow: 0 4px 6px -1px rgba(79, 70, 229, 0.3);
    }

    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 15px -3px rgba(79, 70, 229, 0.4);
    }

    /* تأثيرات الحركة */
    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(10px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .animate-fadeIn {
      animation: fadeIn 0.5s ease-out forwards;
    }

    /* تخصيص شريط التمرير */
    ::-webkit-scrollbar {
      width: 8px;
      height: 8px;
    }

    ::-webkit-scrollbar-track {
      background: #f1f5f9;
    }

    ::-webkit-scrollbar-thumb {
      background-color: #c7d2fe;
      border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
      background-color: #a5b4fc;
    }

    /* تصميم النموذج */
    .form-input {
      transition: all 0.3s ease;
      border: 1px solid #e2e8f0;
      background-color: #f8fafc;
    }

    .form-input:focus {
      border-color: var(--primary-light);
      box-shadow: 0 0 0 3px rgba(129, 140, 248, 0.3);
      background-color: white;
    }
  </style>
</head>

<body class="bg-gray-50">

  <!-- تضمين القائمة الجانبية المشتركة -->
  <?php include_once '../includes/sidebar.php'; ?>

  <!-- المحتوى الرئيسي -->
  <main class="main-content mr-[280px] p-6">
    <!-- عنوان الصفحة -->
    <div class="flex justify-between items-center mb-6">
      <h1 class="text-2xl font-bold text-gray-800">إعدادات الحساب</h1>
    </div>

    <!-- بطاقة الترحيب -->
    <div class="bg-gradient-to-l from-indigo-500 to-indigo-600 rounded-xl shadow-md p-6 mb-8 text-white">
      <div class="flex items-center">
        <div class="w-16 h-16 bg-white/20 rounded-full flex items-center justify-center mr-6">
          <i class="fas fa-user-cog text-3xl"></i>
        </div>
        <div>
          <h2 class="text-xl font-bold mb-2">مرحباً، <?php echo isset($_SESSION['full_name']) ? $_SESSION['full_name'] : 'المستخدم'; ?></h2>
          <p class="text-indigo-100">يمكنك إدارة حسابك وتحديث معلوماتك الشخصية من هنا.</p>
        </div>
      </div>
    </div>

    <!-- معلومات الحساب -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
      <div class="account-card p-6">
        <div class="flex items-center mb-4">
          <div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 ml-3">
            <i class="fas fa-user text-xl"></i>
          </div>
          <h3 class="text-lg font-semibold">المعلومات الشخصية</h3>
        </div>
        <p class="text-gray-600 mb-4">تحديث معلوماتك الشخصية مثل الاسم ورقم الهاتف والبريد الإلكتروني.</p>
        <a href="profile.php" class="text-indigo-600 hover:text-indigo-800 font-medium flex items-center">
          <span>تعديل المعلومات</span>
          <i class="fas fa-arrow-left mr-2"></i>
        </a>
      </div>

      <div class="account-card p-6">
        <div class="flex items-center mb-4">
          <div class="w-12 h-12 rounded-full bg-green-100 flex items-center justify-center text-green-600 ml-3">
            <i class="fas fa-lock text-xl"></i>
          </div>
          <h3 class="text-lg font-semibold">الأمان</h3>
        </div>
        <p class="text-gray-600 mb-4">تغيير كلمة المرور وإعدادات الأمان الخاصة بحسابك.</p>
        <a href="security.php" class="text-indigo-600 hover:text-indigo-800 font-medium flex items-center">
          <span>إعدادات الأمان</span>
          <i class="fas fa-arrow-left mr-2"></i>
        </a>
      </div>

      <div class="account-card p-6">
        <div class="flex items-center mb-4">
          <div class="w-12 h-12 rounded-full bg-purple-100 flex items-center justify-center text-purple-600 ml-3">
            <i class="fas fa-bell text-xl"></i>
          </div>
          <h3 class="text-lg font-semibold">الإشعارات</h3>
        </div>
        <p class="text-gray-600 mb-4">إدارة إعدادات الإشعارات والتنبيهات الخاصة بحسابك.</p>
        <a href="notifications.php" class="text-indigo-600 hover:text-indigo-800 font-medium flex items-center">
          <span>إعدادات الإشعارات</span>
          <i class="fas fa-arrow-left mr-2"></i>
        </a>
      </div>
    </div>

    <!-- نموذج تحديث المعلومات الشخصية -->
    <div class="bg-white rounded-xl shadow-sm p-6 mb-8">
      <h2 class="text-xl font-bold mb-4 flex items-center">
        <i class="fas fa-user text-indigo-600 ml-2"></i>
        <span>المعلومات الشخصية</span>
      </h2>

      <form id="profileForm" class="space-y-4">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label for="fullName" class="block text-sm font-medium text-gray-700 mb-1">الاسم الكامل</label>
            <input type="text" id="fullName" name="fullName" class="form-input w-full rounded-lg" value="<?php echo isset($_SESSION['full_name']) ? $_SESSION['full_name'] : ''; ?>">
          </div>
          <div>
            <label for="username" class="block text-sm font-medium text-gray-700 mb-1">اسم المستخدم</label>
            <input type="text" id="username" name="username" class="form-input w-full rounded-lg" value="<?php echo isset($_SESSION['username']) ? $_SESSION['username'] : ''; ?>" readonly>
          </div>
          <div>
            <label for="email" class="block text-sm font-medium text-gray-700 mb-1">البريد الإلكتروني</label>
            <input type="email" id="email" name="email" class="form-input w-full rounded-lg" value="user@example.com">
          </div>
          <div>
            <label for="phone" class="block text-sm font-medium text-gray-700 mb-1">رقم الهاتف</label>
            <input type="tel" id="phone" name="phone" class="form-input w-full rounded-lg" value="+967 123456789">
          </div>
        </div>

        <div class="flex justify-end">
          <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg font-medium transition-colors duration-300">
            حفظ التغييرات
          </button>
        </div>
      </form>
    </div>

    <!-- تغيير كلمة المرور -->
    <div class="bg-white rounded-xl shadow-sm p-6">
      <h2 class="text-xl font-bold mb-4 flex items-center">
        <i class="fas fa-lock text-indigo-600 ml-2"></i>
        <span>تغيير كلمة المرور</span>
      </h2>

      <form id="passwordForm" class="space-y-4">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label for="currentPassword" class="block text-sm font-medium text-gray-700 mb-1">كلمة المرور الحالية</label>
            <input type="password" id="currentPassword" name="currentPassword" class="form-input w-full rounded-lg">
          </div>
          <div></div>
          <div>
            <label for="newPassword" class="block text-sm font-medium text-gray-700 mb-1">كلمة المرور الجديدة</label>
            <input type="password" id="newPassword" name="newPassword" class="form-input w-full rounded-lg">
          </div>
          <div>
            <label for="confirmPassword" class="block text-sm font-medium text-gray-700 mb-1">تأكيد كلمة المرور الجديدة</label>
            <input type="password" id="confirmPassword" name="confirmPassword" class="form-input w-full rounded-lg">
          </div>
        </div>

        <div class="flex justify-end">
          <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg font-medium transition-colors duration-300">
            تغيير كلمة المرور
          </button>
        </div>
      </form>
    </div>
  </main>

  <!-- سكريبت الصفحة -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // نموذج تحديث المعلومات الشخصية
      const profileForm = document.getElementById('profileForm');
      profileForm.addEventListener('submit', function(e) {
        e.preventDefault();
        // هنا يمكن إضافة كود لإرسال البيانات إلى الخادم
        alert('تم حفظ المعلومات الشخصية بنجاح');
      });

      // نموذج تغيير كلمة المرور
      const passwordForm = document.getElementById('passwordForm');
      passwordForm.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const newPassword = document.getElementById('newPassword').value;
        const confirmPassword = document.getElementById('confirmPassword').value;
        
        if (newPassword !== confirmPassword) {
          alert('كلمة المرور الجديدة وتأكيدها غير متطابقين');
          return;
        }
        
        // هنا يمكن إضافة كود لإرسال البيانات إلى الخادم
        alert('تم تغيير كلمة المرور بنجاح');
        passwordForm.reset();
      });
    });
  </script>
</body>

</html>
