<?php
/**
 * صفحة عرض صلاحيات المستخدم العادي
 * تقوم هذه الصفحة بعرض صلاحيات المستخدم العادي في النظام
 */

// بدء الجلسة
session_start();

// تضمين ملف التكوين
require_once 'config/config.php';

// تضمين ملف الاتصال بقاعدة البيانات
require_once 'config/db_connection.php';

// تضمين ملفات إدارة الصلاحيات
require_once 'includes/permissions.php';

// تفعيل عرض الأخطاء للتصحيح
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// التحقق من حالة تسجيل الدخول
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    // إعادة توجيه المستخدم إلى صفحة تسجيل الدخول
    header('Location: auth/login.php');
    exit;
}

// الحصول على معلومات المستخدم
$user = [
    'id' => $_SESSION['user_id'] ?? 0,
    'username' => $_SESSION['username'] ?? '',
    'full_name' => $_SESSION['full_name'] ?? 'المستخدم',
    'email' => $_SESSION['email'] ?? '',
    'role' => $_SESSION['role'] ?? 'user',
    'branch_id' => $_SESSION['branch_id'] ?? null
];

// تحديد ما إذا كان المستخدم مديرًا
$isAdmin = (isset($_SESSION['role']) && ($_SESSION['role'] === 'admin' || $_SESSION['role'] === 'manager'));

// التحقق من صلاحيات المستخدم للوصول إلى صفحة إدارة المستخدمين
if (!$isAdmin) {
    // إعادة توجيه المستخدم إلى لوحة التحكم
    header('Location: unified-dashboard.php');
    exit;
}

// تعريف صلاحيات المستخدم العادي
$regularUserPermissions = [
    [
        'name' => 'dashboard_view_own',
        'display_name' => 'لوحة التحكم الخاصة بطلباته',
        'description' => 'يمكن للمستخدم العادي عرض لوحة التحكم الخاصة به فقط، والتي تعرض طلباته وإحصائياته الشخصية.'
    ],
    [
        'name' => 'orders_add',
        'display_name' => 'إنشاء طلب خاص به',
        'description' => 'يمكن للمستخدم العادي إنشاء طلبات شحن جديدة خاصة به.'
    ],
    [
        'name' => 'orders_view_own',
        'display_name' => 'إدارة الطلبات الخاصة به',
        'description' => 'يمكن للمستخدم العادي عرض وإدارة الطلبات التي قام بإنشائها فقط.'
    ],
    [
        'name' => 'orders_edit_own',
        'display_name' => 'تعديل الطلبات الخاصة به',
        'description' => 'يمكن للمستخدم العادي تعديل الطلبات التي قام بإنشائها فقط.'
    ],
    [
        'name' => 'orders_manage_own',
        'display_name' => 'إدارة الطلبات الخاصة به',
        'description' => 'يمكن للمستخدم العادي إدارة الطلبات التي قام بإنشائها فقط، مثل متابعة حالتها وتحديثها.'
    ],
    [
        'name' => 'weekly_reports_view_own',
        'display_name' => 'عرض التقارير الأسبوعية الخاصة به',
        'description' => 'يمكن للمستخدم العادي عرض التقارير الأسبوعية المتعلقة بطلباته فقط.'
    ],
    [
        'name' => 'monthly_reports_view_own',
        'display_name' => 'عرض التقارير الشهرية الخاصة به',
        'description' => 'يمكن للمستخدم العادي عرض التقارير الشهرية المتعلقة بطلباته فقط.'
    ],
    [
        'name' => 'support_contact_admin',
        'display_name' => 'صلاحيات الدعم الفني للتواصل مع الإدارة',
        'description' => 'يمكن للمستخدم العادي التواصل مع الإدارة من خلال نظام الدعم الفني في حالة وجود مشكلة أو استفسار.'
    ]
];

// تعيين مسار الشعار
$company_logo = 'assets/images/backgrounds/background.png';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>نظام طلبات الشحن | صلاحيات المستخدم العادي</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="assets/css/unified-design.css">
</head>

<body>
  <!-- طبقة التراكب للأجهزة المحمولة -->
  <div id="overlay" class="overlay"></div>

  <div class="flex min-h-screen">
    <!-- القائمة الجانبية -->
    <?php include 'includes/sidebar.php'; ?>

    <!-- المحتوى الرئيسي -->
    <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50">
      <!-- شريط التنقل العلوي -->
      <header class="bg-white shadow-sm">
        <div class="flex items-center justify-between p-4">
          <!-- زر القائمة للأجهزة المحمولة -->
          <button id="menuBtn" class="md:hidden text-gray-500 hover:text-gray-600 focus:outline-none">
            <i class="fas fa-bars text-xl"></i>
          </button>

          <!-- عنوان الصفحة -->
          <h1 class="text-xl font-semibold text-gray-800">صلاحيات المستخدم العادي</h1>

          <!-- زر العودة -->
          <a href="users.php" class="btn btn-secondary">
            <i class="fas fa-arrow-right ml-2"></i>
            <span>العودة</span>
          </a>
        </div>
      </header>

      <!-- محتوى الصفحة -->
      <div class="p-6">
        <!-- شرح صلاحيات المستخدم العادي -->
        <div class="chart-container animate-fadeIn" style="animation-delay: 0.1s;">
          <h3 class="chart-title">
            <i class="fas fa-user-shield"></i>
            <span>نظرة عامة</span>
          </h3>
          <div class="chart-content">
            <p class="mb-4">
              المستخدم العادي هو المستخدم الذي يملك دور <span class="font-semibold">"موظف"</span> أو <span class="font-semibold">"عميل"</span> في النظام.
              تم تصميم هذه الصلاحيات لتمكين المستخدم العادي من إدارة طلباته الخاصة ومتابعتها، مع الحفاظ على أمان النظام وخصوصية البيانات.
            </p>
          </div>
        </div>

        <!-- قائمة الصلاحيات -->
        <div class="chart-container animate-fadeIn" style="animation-delay: 0.2s;">
          <h3 class="chart-title">
            <i class="fas fa-list-check"></i>
            <span>قائمة صلاحيات المستخدم العادي</span>
          </h3>
          <div class="chart-content">
            <div class="grid grid-cols-1 gap-4">
              <?php foreach ($regularUserPermissions as $permission): ?>
              <div class="bg-white p-4 rounded-lg border border-gray-200 hover:shadow-md transition-all">
                <h3 class="text-lg font-semibold text-primary mb-2"><?php echo htmlspecialchars($permission['display_name']); ?></h3>
                <p class="text-gray-700 mb-2"><?php echo htmlspecialchars($permission['description']); ?></p>
                <div class="text-sm text-gray-500">
                  <span class="font-semibold">اسم الصلاحية في النظام:</span> <?php echo htmlspecialchars($permission['name']); ?>
                </div>
              </div>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
      </div>
    </main>
  </div>

  <!-- سكريبت الصفحة -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // زر القائمة للأجهزة المحمولة
      const menuBtn = document.getElementById('menuBtn');
      const sidebar = document.querySelector('aside');
      const overlay = document.getElementById('overlay');

      if (menuBtn && sidebar && overlay) {
        menuBtn.addEventListener('click', function() {
          sidebar.classList.toggle('hidden');
          overlay.classList.toggle('active');
        });

        overlay.addEventListener('click', function() {
          sidebar.classList.add('hidden');
          overlay.classList.remove('active');
        });
      }
    });
  </script>
</body>

</html>
