# دليل تنظيف وتنظيم المشروع

هذا الدليل يشرح كيفية تنظيف وتنظيم المشروع لإزالة الملفات غير المستخدمة وتحسين هيكل المجلدات.

## 1. الملفات التي يمكن إزالتها

### ملفات الاختبار

هذه الملفات تستخدم للاختبار فقط ويمكن إزالتها من المشروع النهائي:

- test.php
- test_connection.php
- test_db.php
- test_db_connection.php
- test_db_connection_updated.php
- test_login.php
- test_order_number.php
- test-login.php
- test-register.php
- simple-register.php
- login-test.php
- login-test-new.php
- register-simple.php
- debug_register.php
- debug_session.php

### ملفات التكوين المكررة

هذه الملفات مكررة ويمكن توحيدها في ملف تكوين واحد:

- subdomain_config.php
- shipping/config/subdomain_config.php
- shipping/config/deployment.php
- config/deployment.php
- deploy_config.php

### ملفات قاعدة البيانات المكررة

هذه الملفات مكررة ويمكن توحيدها:

- shipping/database/create_orders_table.sql
- shipping/database/create_users_table.sql
- shipping/database/create_sqlite_tables.sql

### ملفات أخرى

هذه الملفات مكررة أو غير ضرورية:

- convert-svg-simple.ps1 (الاحتفاظ بملف واحد فقط)
- convert-svg-to-png.ps1 (الاحتفاظ بملف واحد فقط)
- convert_svg_simple.py
- convert_svg_to_png.py

## 2. هيكل المجلدات المقترح

```
/
├── api/                  # ملفات API
├── assets/               # الأصول الثابتة (الصور، الأيقونات، إلخ)
│   ├── css/              # ملفات CSS
│   ├── js/               # ملفات JavaScript
│   ├── images/           # الصور
│   └── fonts/            # الخطوط
├── config/               # ملفات التكوين
├── database/             # ملفات قاعدة البيانات
├── includes/             # مكونات PHP القابلة لإعادة الاستخدام
├── pages/                # صفحات HTML
├── templates/            # قوالب HTML
└── utils/                # أدوات وسكربتات مساعدة
```

## 3. خطوات التنظيم

### 3.1 إنشاء المجلدات المطلوبة

قم بإنشاء المجلدات التالية إذا لم تكن موجودة:

- api
- assets
- assets/css
- assets/js
- assets/images
- assets/images/logo
- assets/images/flags
- assets/fonts
- config
- database
- includes
- pages
- templates
- utils

### 3.2 نقل الملفات إلى المجلدات المناسبة

#### ملفات HTML

- نقل جميع ملفات HTML (باستثناء index.html) إلى مجلد pages
- الاحتفاظ بـ index.html في المجلد الرئيسي

#### ملفات CSS

- نقل جميع ملفات CSS إلى مجلد assets/css

#### ملفات JavaScript

- نقل جميع ملفات JavaScript إلى مجلد assets/js

#### ملفات الصور

- نقل جميع الصور إلى مجلد assets/images
- نقل أعلام الدول إلى مجلد assets/images/flags
- نقل الشعارات إلى مجلد assets/images/logo

#### ملفات API

- نقل جميع ملفات API إلى مجلد api

#### ملفات التكوين

- نقل جميع ملفات التكوين إلى مجلد config

#### ملفات قاعدة البيانات

- نقل جميع ملفات SQL وملفات قاعدة البيانات إلى مجلد database

#### ملفات المساعدة

- نقل سكربتات التحويل والأدوات المساعدة إلى مجلد utils

### 3.3 تحديث المراجع في الملفات

بعد نقل الملفات، يجب تحديث جميع المراجع في الملفات لتعكس الهيكل الجديد:

- تحديث مسارات الملفات في ملفات HTML
- تحديث مسارات الملفات في ملفات CSS
- تحديث مسارات الملفات في ملفات JavaScript
- تحديث مسارات التضمين في ملفات PHP

## 4. أدوات التنظيم

### 4.1 أداة تنظيم المشروع

تم إنشاء أداة لتنظيم المشروع تلقائيًا. يمكنك استخدامها عن طريق تشغيل الملف التالي:

```
utils/project_organizer.php
```

### 4.2 أداة كشف الملفات غير المستخدمة

تم إنشاء أداة للبحث عن الملفات غير المستخدمة في المشروع. يمكنك استخدامها عن طريق تشغيل الملف التالي:

```
utils/unused_files_detector.php
```

## 5. ملاحظات هامة

- قبل حذف أي ملف، تأكد من أنه غير مستخدم في المشروع
- قم بعمل نسخة احتياطية من المشروع قبل البدء في عملية التنظيم
- بعد الانتهاء من التنظيم، قم باختبار النظام للتأكد من أنه يعمل بشكل صحيح
