<?php
/**
 * مكتبة TCPDF مبسطة لإنشاء ملفات PDF
 * هذه نسخة مبسطة من مكتبة TCPDF للاستخدام في نظام إدارة الطلبات
 */

class TCPDF {
    // خصائص المستند
    protected $orientation = 'P'; // P = Portrait, L = Landscape
    protected $unit = 'mm';
    protected $format = 'A4';
    protected $unicode = true;
    protected $encoding = 'UTF-8';
    protected $diskcache = false;
    
    // خصائص الصفحة
    protected $page = 0;
    protected $pages = [];
    protected $pageWidth = 210;
    protected $pageHeight = 297;
    protected $margins = ['left' => 10, 'top' => 10, 'right' => 10];
    protected $headerMargin = 5;
    protected $footerMargin = 10;
    
    // خصائص الخط
    protected $fontFamily = 'aealarabiya';
    protected $fontSize = 12;
    protected $fontStyle = '';
    
    // خصائص المستند
    protected $creator = '';
    protected $author = '';
    protected $title = '';
    protected $subject = '';
    protected $keywords = '';
    
    // خصائص الرسم
    protected $x = 0;
    protected $y = 0;
    protected $fillColor = [255, 255, 255];
    protected $textColor = [0, 0, 0];
    protected $lineWidth = 0.2;
    
    // خصائص الطباعة
    protected $printHeader = true;
    protected $printFooter = true;
    
    // المحتوى
    protected $content = '';
    
    /**
     * المُنشئ
     */
    public function __construct($orientation = 'P', $unit = 'mm', $format = 'A4', $unicode = true, $encoding = 'UTF-8', $diskcache = false) {
        $this->orientation = $orientation;
        $this->unit = $unit;
        $this->format = $format;
        $this->unicode = $unicode;
        $this->encoding = $encoding;
        $this->diskcache = $diskcache;
        
        // تعيين أبعاد الصفحة
        if ($orientation == 'L') {
            $this->pageWidth = 297;
            $this->pageHeight = 210;
        }
        
        // إضافة الصفحة الأولى
        $this->AddPage();
    }
    
    /**
     * تعيين منشئ المستند
     */
    public function SetCreator($creator) {
        $this->creator = $creator;
    }
    
    /**
     * تعيين مؤلف المستند
     */
    public function SetAuthor($author) {
        $this->author = $author;
    }
    
    /**
     * تعيين عنوان المستند
     */
    public function SetTitle($title) {
        $this->title = $title;
    }
    
    /**
     * تعيين موضوع المستند
     */
    public function SetSubject($subject) {
        $this->subject = $subject;
    }
    
    /**
     * تعيين كلمات مفتاحية للمستند
     */
    public function SetKeywords($keywords) {
        $this->keywords = $keywords;
    }
    
    /**
     * تعيين الهوامش
     */
    public function SetMargins($left, $top, $right = -1) {
        $this->margins['left'] = $left;
        $this->margins['top'] = $top;
        $this->margins['right'] = ($right == -1) ? $left : $right;
    }
    
    /**
     * تعيين هامش الرأس
     */
    public function SetHeaderMargin($margin) {
        $this->headerMargin = $margin;
    }
    
    /**
     * تعيين هامش التذييل
     */
    public function SetFooterMargin($margin) {
        $this->footerMargin = $margin;
    }
    
    /**
     * تعيين طباعة الرأس
     */
    public function setPrintHeader($print) {
        $this->printHeader = $print;
    }
    
    /**
     * تعيين طباعة التذييل
     */
    public function setPrintFooter($print) {
        $this->printFooter = $print;
    }
    
    /**
     * تعيين الخط
     */
    public function SetFont($family, $style = '', $size = 0) {
        $this->fontFamily = $family;
        $this->fontStyle = $style;
        if ($size > 0) {
            $this->fontSize = $size;
        }
    }
    
    /**
     * تعيين لون الخلفية
     */
    public function SetFillColor($r, $g = null, $b = null) {
        if ($g === null && $b === null) {
            $this->fillColor = [$r, $r, $r];
        } else {
            $this->fillColor = [$r, $g, $b];
        }
    }
    
    /**
     * إضافة صفحة جديدة
     */
    public function AddPage() {
        $this->page++;
        $this->pages[$this->page] = '';
        $this->x = $this->margins['left'];
        $this->y = $this->margins['top'];
    }
    
    /**
     * الحصول على الموضع Y الحالي
     */
    public function GetY() {
        return $this->y;
    }
    
    /**
     * تعيين الموضع Y
     */
    public function SetY($y) {
        $this->y = $y;
    }
    
    /**
     * إضافة سطر جديد
     */
    public function Ln($h = null) {
        if ($h === null) {
            $h = $this->fontSize;
        }
        $this->y += $h;
        $this->x = $this->margins['left'];
    }
    
    /**
     * إضافة خلية
     */
    public function Cell($w, $h = 0, $txt = '', $border = 0, $ln = 0, $align = '', $fill = false, $link = '') {
        // إضافة محتوى الخلية
        $this->pages[$this->page] .= "CELL: w=$w, h=$h, txt=$txt, border=$border, ln=$ln, align=$align, fill=" . ($fill ? 'true' : 'false') . "\n";
        
        // تحديث الموضع
        if ($ln == 1) {
            $this->y += $h;
            $this->x = $this->margins['left'];
        } else {
            $this->x += $w;
        }
    }
    
    /**
     * الحصول على رقم الصفحة الحالي
     */
    public function getAliasNumPage() {
        return $this->page;
    }
    
    /**
     * الحصول على إجمالي عدد الصفحات
     */
    public function getAliasNbPages() {
        return count($this->pages);
    }
    
    /**
     * إخراج المستند
     */
    public function Output($name = 'doc.pdf', $dest = 'I') {
        // في هذه النسخة المبسطة، سنقوم بإنشاء ملف نصي بدلاً من PDF
        $output = "PDF Document\n";
        $output .= "Title: {$this->title}\n";
        $output .= "Author: {$this->author}\n";
        $output .= "Creator: {$this->creator}\n";
        $output .= "Subject: {$this->subject}\n";
        $output .= "Keywords: {$this->keywords}\n";
        $output .= "Pages: " . count($this->pages) . "\n\n";
        
        foreach ($this->pages as $pageNum => $pageContent) {
            $output .= "Page $pageNum:\n";
            $output .= $pageContent;
            $output .= "\n";
        }
        
        // تحديد نوع المحتوى
        header('Content-Type: application/pdf');
        
        // تحديد اسم الملف للتنزيل
        header('Content-Disposition: attachment; filename="' . $name . '"');
        
        // إخراج المحتوى
        echo $output;
        
        return '';
    }
}
?>
